/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.data;

import com.mojang.serialization.MapCodec;
import com.robocraft999.creategoggles.registry.CGRecipeTypes;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record NBTCraftingRecipe(ShapedRecipe recipe) implements CraftingRecipe
{
    public boolean matches(@Nonnull CraftingInput input, @Nonnull Level worldIn) {
        return this.recipe().matches(input, worldIn);
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        return this.recipe.getIngredients();
    }

    @Nonnull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        HashMap allEnchants = new HashMap();
        ItemStack nbtItemResult = ItemStack.EMPTY;
        for (int slot = 0; slot < input.size(); ++slot) {
            ItemEnchantments ench;
            ItemStack nbtItem = input.getItem(slot).copy();
            if (nbtItem.isEmpty() || !nbtItem.isEnchantable() && !nbtItem.isEnchanted()) continue;
            if (nbtItemResult.isEmpty()) {
                nbtItemResult = new ItemStack((ItemLike)this.getResultItem(provider).getItem());
            }
            if ((ench = (ItemEnchantments)nbtItem.get(DataComponents.ENCHANTMENTS)) == null) continue;
            ench.entrySet().forEach(entry -> allEnchants.put((Holder)entry.getKey(), entry.getIntValue()));
        }
        if (!allEnchants.isEmpty() || !nbtItemResult.isEmpty()) {
            for (Map.Entry entry2 : allEnchants.entrySet()) {
                Holder enchantment = (Holder)entry2.getKey();
                if (nbtItemResult.getEnchantmentLevel(enchantment) != 0) continue;
                nbtItemResult.enchant(enchantment, ((Integer)entry2.getValue()).intValue());
            }
        }
        return nbtItemResult;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.recipe().getResultItem(provider);
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)CGRecipeTypes.CRAFTING_NBT.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return this.recipe().canCraftInDimensions(width, height);
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.EQUIPMENT;
    }

    public static class Serializer
    implements RecipeSerializer<NBTCraftingRecipe> {
        public static final MapCodec<NBTCraftingRecipe> CODEC = RecipeSerializer.SHAPED_RECIPE.codec().xmap(NBTCraftingRecipe::new, NBTCraftingRecipe::recipe);
        public static final StreamCodec<RegistryFriendlyByteBuf, NBTCraftingRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(NBTCraftingRecipe::new, NBTCraftingRecipe::recipe);

        public MapCodec<NBTCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NBTCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

